

   MEMBER('client.clw')                                    ! This is a MEMBER module


   INCLUDE('ABTOOLBA.INC'),ONCE
   INCLUDE('ABWINDOW.INC'),ONCE

                     MAP
                       INCLUDE('CLIEN001.INC'),ONCE        !Local module procedure declarations
                     END


  
Main PROCEDURE                                             ! Generated from procedure template - Window

PostString           STRING(1024)                          !
ResultGroup          GROUP,PRE(result)                     !
api                  STRING(30),NAME('aws:api')            !
version              STRING(20)                            !
weburl               STRING(30),NAME('aws:WebURL')         !
station              STRING(30),NAME('aws:station')        !
requestedID          STRING(30)                            !
id                   STRING(30)                            !
name                 STRING(100)                           !
city                 STRING(100)                           !
state                STRING(100)                           !
citycode             STRING(30)                            !
latitude             STRING(30)                            !
longitude            STRING(30)                            !
currentCondition     STRING(30),NAME('aws:current-condition') !
tempunits            CSTRING(11),NAME('units')             !
temp                 CSTRING(11),NAME('aws:temp')          !
rainunits            STRING(20),NAME('units')              !
raintoday            STRING(20),NAME('aws:rain-today')     !
windspeedunits       STRING(20),NAME('units')              !
windspeed            STRING(20),NAME('aws:wind-speed')     !
gustspeedunits       STRING(20),NAME('units')              !
gustspeed            STRING(20),NAME('aws:gust-speed')     !
gustdirection        STRING(20),NAME('aws:gust-direction') !
                     END                                   !
window               WINDOW('XML Example'),AT(,,408,265),FONT('Arial',10,COLOR:Black,FONT:regular,CHARSET:ANSI),IMM,ICON('school.ico'),SYSTEM,GRAY,DOUBLE,AUTO
                       GROUP,AT(16,8,352,224),USE(?StudentGroup),BOXED
                         PROMPT('name:'),AT(29,18),USE(?name:Prompt)
                         ENTRY(@s100),AT(81,18,60,10),USE(result:name)
                         PROMPT('city:'),AT(169,22),USE(?city:Prompt)
                         ENTRY(@s100),AT(221,22,60,10),USE(result:city)
                         PROMPT('state:'),AT(33,38),USE(?state:Prompt)
                         ENTRY(@s100),AT(85,38,60,10),USE(result:state)
                         PROMPT('citycode:'),AT(173,42),USE(?citycode:Prompt)
                         ENTRY(@s30),AT(225,42,60,10),USE(result:citycode)
                         PROMPT('latitude:'),AT(41,58),USE(?latitude:Prompt)
                         ENTRY(@s30),AT(93,58,60,10),USE(result:latitude)
                         PROMPT('longitude:'),AT(185,62),USE(?longitude:Prompt)
                         ENTRY(@s30),AT(237,62,60,10),USE(result:longitude)
                         PROMPT('current Condition:'),AT(29,78),USE(?currentCondition:Prompt)
                         ENTRY(@s30),AT(81,78,60,10),USE(result:currentCondition)
                         PROMPT('tempunits:'),AT(28,96),USE(?result:tempunits:Prompt:2)
                         ENTRY(@s10),AT(80,96,60,10),USE(result:tempunits,,?result:tempunits:2)
                         PROMPT('temp:'),AT(189,102),USE(?result:temp:Prompt)
                         ENTRY(@s10),AT(241,102,60,10),USE(result:temp)
                         PROMPT('rainunits:'),AT(37,126),USE(?rainunits:Prompt)
                         ENTRY(@s20),AT(89,126,60,10),USE(result:rainunits)
                         PROMPT('raintoday:'),AT(193,126),USE(?raintoday:Prompt)
                         ENTRY(@s20),AT(245,126,60,10),USE(result:raintoday)
                         PROMPT('windspeedunits:'),AT(41,154),USE(?result:windspeedunits:Prompt)
                         ENTRY(@s20),AT(93,154,60,10),USE(result:windspeedunits)
                         PROMPT('windspeed:'),AT(201,154),USE(?result:windspeed:Prompt)
                         ENTRY(@s20),AT(253,154,60,10),USE(result:windspeed)
                         PROMPT('gustspeedunits:'),AT(45,178),USE(?gustspeedunits:Prompt)
                         ENTRY(@s20),AT(97,178,60,10),USE(result:gustspeedunits)
                         PROMPT('gustspeed:'),AT(205,182),USE(?gustspeed:Prompt)
                         ENTRY(@s20),AT(257,182,60,10),USE(result:gustspeed)
                         PROMPT('gustdirection:'),AT(137,214),USE(?gustdirection:Prompt)
                         ENTRY(@s20),AT(189,214,60,10),USE(result:gustdirection)
                       END
                       BUTTON('Get Info'),AT(116,240,50,14),USE(?GetStudent)
                       BUTTON('Close'),AT(188,240,50,14),USE(?Close)
                     END

ThisWindow           CLASS(WindowManager)
Init                   PROCEDURE(),BYTE,PROC,DERIVED       ! Method added to host embed code
Kill                   PROCEDURE(),BYTE,PROC,DERIVED       ! Method added to host embed code
TakeAccepted           PROCEDURE(),BYTE,PROC,DERIVED       ! Method added to host embed code
                     END

Toolbar              ToolbarClass
xml                  Class(xFileXML)
Constructor            PROCEDURE () ,VIRTUAL
SaveTweakSettings      PROCEDURE () ,VIRTUAL
LoadTweakSettings      PROCEDURE () ,VIRTUAL
                     End

  CODE
  GlobalResponse = ThisWindow.Run()                        ! Opens the window and starts an Accept Loop

!---------------------------------------------------------------------------
DefineListboxStyle ROUTINE
!|
!| This routine create all the styles to be shared in this window
!| It`s called after the window open
!|
!---------------------------------------------------------------------------

ThisWindow.Init PROCEDURE

ReturnValue          BYTE,AUTO

  CODE
  GlobalErrors.SetProcedureName('Main')
  SELF.Request = GlobalRequest                             ! Store the incoming request
  ReturnValue = PARENT.Init()
  IF ReturnValue THEN RETURN ReturnValue.
  SELF.FirstField = ?name:Prompt
  SELF.VCRRequest &= VCRRequest
  SELF.Errors &= GlobalErrors                              ! Set this windows ErrorManager to the global ErrorManager
  SELF.AddItem(Toolbar)
  CLEAR(GlobalRequest)                                     ! Clear GlobalRequest after storing locally
  CLEAR(GlobalResponse)
  IF SELF.Request = SelectRecord
     SELF.AddItem(?Close,RequestCancelled)                 ! Add the close control to the window manger
  ELSE
     SELF.AddItem(?Close,RequestCompleted)                 ! Add the close control to the window manger
  END
  SELF.Open(window)                                        ! Open window
  Do DefineListboxStyle
  INIMgr.Fetch('Main',window)                              ! Restore window settings from non-volatile store
  SELF.SetAlerts()
  RETURN ReturnValue


ThisWindow.Kill PROCEDURE

ReturnValue          BYTE,AUTO

  CODE
  ReturnValue = PARENT.Kill()
  IF ReturnValue THEN RETURN ReturnValue.
  IF SELF.Opened
    INIMgr.Update('Main',window)                           ! Save window data to non-volatile store
  END
  GlobalErrors.SetProcedureName
  RETURN ReturnValue


ThisWindow.TakeAccepted PROCEDURE

ReturnValue          BYTE,AUTO

Looped BYTE
  CODE
  LOOP                                                     ! This method receive all EVENT:Accepted's
    IF Looped
      RETURN Level:Notify
    ELSE
      Looped = 1
    END
  ReturnValue = PARENT.TakeAccepted()
    CASE ACCEPTED()
    OF ?GetStudent
      ThisWindow.Update
        clear(resultGroup)
        !Randy Rogers got this back from his post to the server:
      !    <aws:weather xmlns:aws="http://www.aws.com/aws">
      !    <aws:api version="2.0" />
      !    <aws:WebURL>http://weather.weatherbug.com/Canada/Wiarton-weather.html?ZCode=Z5546&Units=1&stat=CYVV</aws:WebURL>
      !    <aws:InputLocationURL>http://weather.weatherbug.com/Canada/Wiarton-weather.html?ZCode=Z5546&Units=1</aws:InputLocationURL>
      !    <aws:station requestedID="" id="CYVV" name="Wiarton Airport"
      !    city="Wiarton" state="Canada" citycode="CYVV" country="Canada"
      !    latitude="44.75" longitude="-81.0999984741211" />
      !    <aws:current-condition icon="http://deskwx.weatherbug.com/images/Forecast/icons/cond001.gif">Cloudy</aws:current-condition>
      !    <aws:temp units="&deg;C">15.0</aws:temp>
      !    <aws:rain-today units="mm">0.00</aws:rain-today>
      !    <aws:wind-speed units="km/h">13</aws:wind-speed>
      !    <aws:wind-direction>S</aws:wind-direction>
      !    <aws:gust-speed units="km/h">14</aws:gust-speed>
      !    <aws:gust-direction>SE</aws:gust-direction>
      !   </aws:weather>
      
        !So to just make it easy as example, i took the above and just put it into a string below and formatted it
        PostString = '<aws:weather xmlns:aws="http://www.aws.com/aws"><13,10><aws:api version="2.0" /><13,10>'
        PostString = CLIP(PostString) & '<aws:WebURL>http://weather.weatherbug.com/Canada/Wiarton-weather.html?ZCode=Z5546&Units=1&stat=CYVV</aws:WebURL><13,10>'
        PostString = CLIP(PostString) & '<aws:station requestedID="" id="CYVV" name="Wiarton Airport"<13,10>'
        PostString = CLIP(PostString) & 'city="Wiarton" state="Canada" citycode="CYVV" country="Canada"<13,10>latitude="44.75" longitude="-81.0999984741211" /><13,10>'
        PostString = CLIP(PostString) & '<aws:current-condition icon="http://deskwx.weatherbug.com/images/Forecast/icons/cond001.gif">Cloudy</aws:current-condition><13,10>'
        PostString = CLIP(PostString) & '<aws:temp units="&deg;C">15.0</aws:temp><13,10>'
        PostString = CLIP(PostString) & '<aws:rain-today units="mm">0.00</aws:rain-today><13,10>'
        PostString = CLIP(PostString) & '<aws:wind-speed units="km/h">13</aws:wind-speed><13,10>'
        PostString = CLIP(PostString) & '<aws:wind-direction>S</aws:wind-direction><13,10><aws:gust-speed units="km/h">14</aws:gust-speed><13,10>'
        PostString = CLIP(PostString) & '<aws:gust-direction>SE</aws:gust-direction><13,10></aws:weather>'
      
        !In a simple xml file with clearer names, the order of the variables in your group or queue doesnt really matter that much, but in this case the
        !order is crucial and it seems you need to define all the fields, although you only may need some, else the order goes out.
        !From the capesoft xfiles docs:
      
      !  Notice also that the order of the fields is critical. Without the ability to match exclusively on the name, xFiles will take the order of the
      !  fields into account. Lastly notice that the attribute comes before the field. so the Type comes before the Price.
      
        !So in our case, the units will become before each weather description, e.g. Units and then Temp, Units and then Windspeed, etc
        !Last thing to remember is that xml is case sensitive and to use the external name field
      
        xml.load(resultGroup,PostString,len(PostString))
        display()
    END
    RETURN ReturnValue
  END
  ReturnValue = Level:Fatal
  RETURN ReturnValue

! bruce
!----------------------------------------------------
xml.Constructor   PROCEDURE ()
  CODE
    PARENT.Constructor ()
          self.SaveStringsAsCData = 0
          self.SaveMEMOsAsCData = 1
          self.SaveBLOBsAsCData = 1
          self._ReplaceColons = 1
          self.RemovePrefix = 1
          self.DontUseMemos = 0
          self.DontUseBLOBs = 0
    
    
          self.freeQueueBeforeLoad = 1
          self.freeGroupBeforeLoad = 0
          self.freeFileBeforeLoad = 0
          self.UpdateFileOnLoad = 0
    
!----------------------------------------------------
xml.SaveTweakSettings   PROCEDURE ()
  CODE
    PARENT.SaveTweakSettings ()
  Xml.SOAPEnvelope     = 1                   ! tells xFiles to wrap the XML in a SOAP envelope
  Xml.SaveEncoding = 'utf-8'                 ! default is 'ISO-8859-1'
  Xml._pfileBoundary = ''
  Xml._pRecordBoundary = 'aws:weather'
  Xml.TagCase = XF:CaseAsIs
                                      
!----------------------------------------------------
xml.LoadTweakSettings   PROCEDURE ()
  CODE
    PARENT.LoadTweakSettings ()
  Xml._pfileBoundary = ''
  Xml._pRecordBoundary = 'aws:weather'
